'use strict';
angular.module('data_models', [])
    .factory('User', ['$http', '$q', 'AppConfig', function($http, $q, AppConfig){
        function User(userData){
            this.setData(userData);
        }

        User.prototype = {
            _selected: false
            ,actualTokensList: {}
            ,setData: function(userData){
                angular.extend(this, userData);
            }
            ,save: function(callbackSuccess, callbackError){
                var scope = this;
                $http.post(AppConfig.urlUser, this)
                    .success(function(data){
                        angular.extend(scope, data);
                        if(typeof callbackSuccess != 'undefined')
                        {
                            callbackSuccess(scope, data);
                        }
                    })
                    .error(function(data){
                        if(typeof callbackError != 'undefined')
                        {
                            callbackError(scope, data);
                        }
                    })
                ;
            }
            ,destroy: function(callbackIfSuccess){
                var scope = this;
                $http.delete(AppConfig.urlUser + '/' + this.id)
                    .success(function(data){
                        callbackIfSuccess();
                    })
                    .error(function(){
                    })
                ;
            }
            ,loadTokens: function(){
                var scope = this;
                $http.get(AppConfig.urlUserTokens + '/' + this.id)
                    .success(function(tokensList){
                        scope.actualTokensList = tokensList;
                    })
                    .error(function(){
                    })
                ;
            }
            ,generateNewTokensList: function(){
                var scope = this;
                $http.post(AppConfig.urlUserTokens + '/' + this.id)
                    .success(function(tokensList){
                        scope.actualTokensList = tokensList;
                    })
                    .error(function(){
                    })
                ;
            }
            ,select: function(){
                this._selected = true;
            }
            ,unselect: function(){
                this._selected = false;
            }
            ,isSelected: function(){
                return this._selected;
            }
        }

        return User;
    }])
    .factory('Group', ['$http', '$rootScope', 'User', 'AppConfig', function($http, $rootScope, User, AppConfig){

        function Group(groupData){
            this.setData(groupData);
        }

        Group.prototype = {
            company: []
            ,_transform: function(users){
                users.forEach(function(userData, i){
                    if(typeof users[i] != 'User')
                    {
                        users[i] = new User(userData);
                    }
                });
                return users;
            }
            ,setData: function(groupData){
                this._transform(groupData.users);
                angular.extend(this, groupData);
            }
            ,addUser: function(userData){
                var scope = this;
                var user = new User(userData)
                user.save(function(user, data){
                    if(typeof data.error == 'undefined')
                    {
                        scope.users.push(user);
                    }
                    else
                    {
                        $rootScope.$broadcast('Message:error', data.error);
                    }
                });
            }
            ,checkUser: function(userData, callback){
                $http.post(AppConfig.urlCheckUser, {email: userData.email})
                    .success(function(data){
                        callback(data);
                    })
                ;
            }
            ,save: function(){
                var scope = this;
                $http.post(AppConfig.urlGroup, this)
                    .success(function(data){
                        angular.extend(scope, data);
                        scope._transform(scope.users);
                    })
                ;
            }
            ,getSelectedUsers: function(){
                var users = [];
                this.users.forEach(function(user){
                    if(user.isSelected()){
                        users.push(user);
                    }
                })
                return users;
            }
            ,getCompanyName: function(){
                return (typeof this.company != 'undefined' && this.company != null && this.company.length > 0) ? this.company[0].name : 'brak firmy';
            }
        }

        return Group;
    }])
    .factory('GroupsManager', ['$http', '$q', 'Group', 'AppConfig', function($http, $q, Group, AppConfig){
        var groupsManager = {
            _loadedAllData: false
            ,_groups: []

            ,findGroup: function(groupId){
                var g = false;
                for(var i = 0; i < this._groups.length; i++)
                {
                    if(this._groups[i].id == groupId)
                    {
                        g = this._groups[i];
                        break;
                    }
                }
                return g;
            }
            ,_retrieveInstance: function(groupId, groupData) {
                var instance = this.findGroup(groupId);

                if(instance)
                {
                    instance.setData(groupData);
                }
                else
                {
                    instance = new Group(groupData);
                    this._groups.push(instance);
                }

                return instance;
            }

            /**
             * Load all groups and add them to local array
             *
             * @returns {*}
             */
            ,loadAllGroups: function(){
                if(this._loadedAllData)
                {
                    return this._groups;
                }
                var deferred = $q.defer();
                var scope = this;
                $http.get(AppConfig.urlGroup)
                    .success(function(groupsArray){
                        groupsArray.forEach(function(groupData){
                            var group = scope._retrieveInstance(groupData.id, groupData);
                        });

                        scope._loadedAllData = true;
                        deferred.resolve(scope._groups);
                    })
                    .error(function(){
                        deferred.reject();
                    });
                return deferred.promise;
            }
            ,setGroup: function(groupData){
                var scope = this;
                var group = this.findGroup(groupData.id);
                if (group)
                {
                    group.setData(groupData);
                }
                else
                {
                    group = scope._retrieveInstance(groupData.id, groupData);
                }
                group.save();
                return group;
            }
            ,removeGroup: function(group){
                this._groups.splice(this._groups.indexOf(group), 1);
            }
        }

        return groupsManager;
    }])
    .factory('Round', ['$http', 'AppConfig', function($http, AppConfig){
        function Round(roundData){
            this.setData(roundData);
        }

        Round.prototype = {
            _isWrongStartDate: false
            ,isWrong: function(){
                return this._isWrongStartDate;
            }
            ,isEmptyStartDate: function(){
                return (this.start_at == null || this.start_at == '' || typeof this.start_at == 'undefined');
            }
            ,isStarted: function(){
                var d = new Date();
                var curr_date = d.getDate();
                curr_date = (curr_date < 10) ? '0' + curr_date : curr_date;
                var curr_month = d.getMonth() + 1; //Months are zero based
                curr_month = (curr_month < 10) ? '0' + curr_month : curr_month;
                var curr_year = d.getFullYear();
                var curr_hour = d.getHours();
                curr_hour = (curr_hour < 10) ? '0' + curr_hour : curr_hour;
                var curr_minutes = d.getMinutes();
                curr_minutes = (curr_minutes < 10) ? '0' + curr_minutes : curr_minutes;
                var curr_seconds = d.getSeconds();
                curr_seconds = (curr_seconds < 10) ? '0' + curr_seconds : curr_seconds;

                return this.start_at <= curr_year + "-" + curr_month + "-" + curr_date + ' ' + curr_hour + ':' + curr_minutes + ':' + curr_seconds;
            }
            ,setData: function(roundData){
                angular.extend(this, roundData);
            }
            ,save: function(callback){
                var scope = this;
                $http.post(AppConfig.urlRounds, this)
                    .success(function(data){
                        if(typeof callback !== 'undefined')
                        {
                            callback(data);
                        }
                    })
                ;
            }
            ,setWrong: function(wrong){
                this._isWrongStartDate = wrong;
            }
        }

        return Round;
    }])
    .factory('RoundsManager', ['$http', '$q', 'Round', 'AppConfig', function($http, $q, Round, AppConfig){
        var RoundsManager;

        RoundsManager = (function(){
            function RoundsManager(roundsData){
                this._loadedAllData = false;
                this._rounds = [];
                this.setData(roundsData);
            }

            RoundsManager.prototype._getPreviousRound = function(round){
                var index = this._rounds.indexOf(round);
                return (index > 0) ? this._rounds[--index] : false;
            };

            RoundsManager.prototype._getNextRound = function(round){
                var index = this._rounds.indexOf(round);
                return (index < this._rounds.length - 1) ? this._rounds[++index] : false;
            };

            RoundsManager.prototype._isFirst = function(round){
                return this._rounds.indexOf(round) === 0;
            };

            RoundsManager.prototype._isLast = function(round){
                return this._rounds.indexOf(round) === this._rounds.length - 1;
            };

            RoundsManager.prototype.setData = function(roundsArray){
                var me = this;
                roundsArray.forEach(function(roundData){
                    me._rounds.push(new Round(roundData));
                });
                this._loadedAllData = true;
            };

            RoundsManager.prototype.getRounds = function(){
                return this._rounds;
            };

            RoundsManager.prototype.isEndedRound = function(Round){
                var PrevRound = this._getPreviousRound(Round);
                if(PrevRound !== false && !PrevRound.is_done)
                {
                    return false;
                }

                var NextRound = this._getNextRound(Round);
                if(NextRound == false)
                {
                    return true;
                }
                else
                {
                    if(!NextRound.isStarted())
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            };

            RoundsManager.prototype.validateRounds = function(){
                var countWrongs = 0;
                this._rounds.forEach(function(round){
                    if(!this._isLast(round))
                    {
                        var nextRound = this._getNextRound(round);
                        if(!nextRound.isEmptyStartDate() && round.start_at >= nextRound.start_at)
                        {
                            nextRound.setWrong(true);
                            countWrongs++;
                        }
                    }
                    else
                    {
                        var prevRound = this._getPreviousRound(round);
                        if(!round.isEmptyStartDate() && (prevRound.start_at >= round.start_at || prevRound.isEmptyStartDate()))
                        {
                            round.setWrong(true);
                            countWrongs++;
                        }
                    }

                    if(!this._isFirst(round) && !this._isLast(round))
                    {
                        var prevRound = this._getPreviousRound(round);
                        if(prevRound.isEmptyStartDate() && !round.isEmptyStartDate())
                        {
                            round.setWrong(true);
                            countWrongs++;
                        }
                    }

                }, this);

                return (countWrongs == 0);
            };

            RoundsManager.prototype.setAllRoundsAsCorrect = function(){
                this._rounds.forEach(function(round){
                    round.setWrong(false);
                });
            };

            return RoundsManager;
        })();

        return RoundsManager;
    }])
    .factory('GroupRounds', ['$http', 'AppConfig', 'RoundsManager', function($http, AppConfig, RoundsManager){
        var GroupRounds;

        GroupRounds = (function() {
            function GroupRounds(groupData) {
                this.RoundsManager = {};
                this.setData(groupData);
            }

            GroupRounds.prototype.setData = function(groupData) {
                angular.extend(this, groupData);
                return this.RoundsManager = new RoundsManager(groupData.rounds);
            };

            GroupRounds.prototype.save = function(callback) {
                var scope = this;
                $http.post(AppConfig.urlRounds, this)
                    .success(function(data){
                        if(typeof callback !== 'undefined')
                        {
                            callback(data);
                        }
                    })
                ;
            };

            return GroupRounds;

        })();

        return GroupRounds;
    }])
    .factory('GroupsRoundsManager', ['$http', '$q', 'GroupRounds', 'AppConfig', function($http, $q, GroupRounds, AppConfig){
        var GroupsRoundsManager = {
            _loadedAllData: false
            ,_groups: []
            ,clearAll: function(){
                this._loadedAllData = false;
                this._groups = [];
            }
            ,_getPreviousGroup: function(group){
                var index = this._groups.indexOf(group);
                return (index > 0) ? this._groups[--index] : false;
            }
            ,_getNextGroup: function(group){
                var index = this._groups.indexOf(group);
                return (index < this._groups.length - 1) ? this._groups[++index] : false;
            }
            ,_isFirst: function(group){
                return this._groups.indexOf(group) === 0;
            }
            ,_isLast: function(group){
                return this._groups.indexOf(group) === this._groups.length - 1;
            }
            ,loadGroups: function(){
                if(this._loadedAllData)
                {
                    return this._groups;
                }
                var deferred = $q.defer();
                var scope = this;
                $http.get(AppConfig.urlRounds)
                    .success(function(groupsArray){
                        groupsArray.forEach(function(group){
                            scope._groups.push(new GroupRounds(group));
                        });

                        scope._loadedAllData = true;
                        deferred.resolve(scope._groups);
                    })
                    .error(function(){
                        deferred.reject();
                    });
                return deferred.promise;
            }

            ,setGroupRoundData: function(groupData){
                var groupRound;
                angular.forEach(this._groups, function(GroupRound){
                    if(GroupRound.id === groupData.id)
                    {
                        GroupRound.setData(groupData);
                    }
                });
            }

            ,validateGroupsRounds: function(){
                var validationPassed = 0;
                this._groups.forEach(function(group){
                    if(!this._isFirst(group) && !this._isLast(group))
                    {
                        var prevGroup = this._getPreviousGroup(group);
                        validationPassed =
                            group.RoundsManager.validateRounds()
                            &&
                            prevGroup.RoundsManager.validateRounds();
                    }
                    else
                    {
                        if(this._isFirst(group))
                        {
                            validationPassed = group.RoundsManager.validateRounds()
                        }
                        else
                        {
                            var prevGroup = this._getPreviousGroup(group);
                            validationPassed =
                                group.RoundsManager.validateRounds()
                                &&
                                prevGroup.RoundsManager.validateRounds();
                        }
                    }

                }, this);

                return validationPassed;
            }
            ,setAllGroupsRoundsAsCorrect: function(){
                this._groups.forEach(function(group){
                    group.RoundsManager.setAllRoundsAsCorrect()
                });
            }
        }

        return GroupsRoundsManager;
    }])
    .factory('UserLog', [function(){
        function UserLog(userData){
            this.setData(userData)
        }

        UserLog.prototype = {
            setData: function(userData){
                userData.username = userData.name + ' ' + userData.surname;
                angular.extend(this, userData);
            }
        }

        return UserLog;
    }])
    .factory('UserLogManager', ['$http', '$q', 'AppConfig', 'UserLog', function($http, $q, AppConfig, UserLog){
        var usersLogManager = {
            _users: []
            ,_isLoadedData: false
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this._users;
                }
                var scope = this;
                var deferred = $q.defer();
                $http.get(AppConfig.urlUsersAccess)
                    .success(function(data){
                        scope._users = [];
                        data.forEach(function(groupData){
                            groupData.users.forEach(function(userData){
                                userData.group_name = groupData.name;
                                scope._users.push(new UserLog(userData));
                            });
                        });
                        scope._isLoadedData = true;
                        deferred.resolve(scope._users);
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }

        }

        return usersLogManager;
    }])
    .factory('RankingManager', ['$http', '$q', 'AppConfig', function($http, $q, AppConfig){
        var RankingManager = {
            _groups: []
            ,loadData: function(dateStart, dateEnd){
                var scope = this;
                var deferred = $q.defer();
                $http.post(AppConfig.urlRanking, {start_date: dateStart, end_date: dateEnd})
                    .success(function(data){
                        scope._groups = data;
                        deferred.resolve(scope._groups);
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }

        }

        return RankingManager;
    }])
    .factory('Settings', [function(){
        function Settings(settingsData){
            this.setData(settingsData)
        }

        Settings.prototype = {
            _selected: false
            ,setData: function(settingsData){
                angular.extend(this, settingsData);
            }
            ,select: function(){
                this._selected = true;
            }
            ,unselect: function(){
                this._selected = false;
            }
            ,isSelected: function(){
                return this._selected;
            }
        }

        return Settings;
    }])
    .factory('SettingsManager', ['$http', '$q', '$rootScope', 'AppConfig', 'Settings', function($http, $q, $rootScope, AppConfig, Settings){
        var settingsManager = {
            list: []
            ,_isLoadedData: false
            ,_getItem: function(id){
                var item = false;
                this.list.forEach(function(Item){
                    if(Item.id == id)
                    {
                        item = Item;
                    }
                });
                return item;
            }
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this.list;
                }
                var scope = this;
                var deferred = $q.defer();
                $http.get(AppConfig.urlSettings)
                    .success(function(data){
                        data.forEach(function(item){
                            scope.list.push(new Settings(item))
                        });
                        scope._isLoadedData = true;

                        $http.get(AppConfig.urlSettings + '/selected')
                            .success(function(data){
                                var Item = scope._getItem(data.id);
                                if(Item != false)
                                {
                                    Item.select();
                                }
                                deferred.resolve(scope.list);
                            })
                            .error(function(){
                                deferred.reject();
                            })
                        ;
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }
            ,selectSegment: function(item){
                this.list.forEach(function(Item){
                    Item.unselect();
                });
                item.select();

                var scope = this;

                $http.post(AppConfig.urlSettings, item)
                    .success(function(data){
                        scope.list.forEach(function(Item){
                            Item.unselect();
                        });
                        var Item = scope._getItem(data['id']);
                        Item.select();

                        if(typeof data.error != 'undefined')
                        {
                            $rootScope.$broadcast('Settings:changeMarketSegmentError', data.error);
                        }
                    })
                    .error(function(){
                    })
                ;
            }
            ,getSelectedSegment: function(){
                var item = {};
                this.list.forEach(function(Item){
                    if(Item.isSelected())
                    {
                        item = Item;
                    }
                });
                return item;
            }
        }

        return settingsManager;
    }])
    .factory('GroupResults', ['$http', '$q', '$rootScope', 'AppConfig', function($http, $q, $rootScope, AppConfig){
        var GroupResults = {
            list: []
            ,_isLoadedData: false
            ,clearAll: function(){
                this.list = [];
                this._isLoadedData = false;
            }
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this.list;
                }
                var scope = this;
                var deferred = $q.defer();
                $http.get(AppConfig.urlGroupResults)
                    .success(function(data){
                        scope._isLoadedData = true;
                        scope.list = data;

                        deferred.resolve(scope.list);
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }
        }

        return GroupResults;
    }])
;